---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, légendes, légendes des figures, 
              légendes des tableaux, mise en forme des légendes
---

# Comment modifier la commande `\caption` ?

## Modification du titre prédéfini des légendes

### Avec les commandes de base

S'il s'agit juste de modifier les mots "Figure" et "Table" qui sont affichés 
avant le titre de la légende, il suffit de redéfinir les commandes 
`\figurename` et `\tablename`, respectivement.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{mwe}            % Pour inclure des images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \renewcommand{\figurename}{Illustration}

\begin{document}
Comme le dit la Wikipédia, A (capitale : A, minuscule : a) est la première 
lettre de l'alphabet latin ainsi que sa première voyelle.
\begin{figure}[ht]
  \centering
  \includegraphics[width=.5\linewidth]{example-image-a}
  \caption{La lettre A}
\end{figure}
\end{document}
```

Ce sujet est traité plus en détail dans la question 
"[](/3_composition/langues/traduire_le_titre_de_table_des_matieres_ou_bibliographie)"


### Avec l'extension <ctanpkg:babel>

Avec l'extension <ctanpkg:babel>, la technique ci-dessus ne fonctionne 
parfois pas bien. En effet, <ctanpkg:babel> redéfinit lui-même 
ces deux commandes *à chaque changement de langue*, et les modifications 
risquent donc d'être perdues.

Pour contourner ce problème, vous pouvez écrire :

```{noedit}
\renewcommand*\frenchfigurename{%
    {\scshape Figure}%
}
\renewcommand*\frenchtablename{%
    {\scshape Tableau}%
}
```


## Modification de la mise en forme des légendes

### Avec l'extension <ctanpkg:caption>

S'il s'agit de changer la mise en forme de la légende, l'extension
<ctanpkg:caption> permet de configurer très précisément le comportement de
`\caption` par le biais de sa commande `\captionsetup`.

Les exemples suivants montrent quelques-unes des possibilités de redéfinitions
de légendes qu'offre cette extension.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Pour inclure des images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{caption}

\begin{document}
Du texte, du texte, du texte, du texte, du texte, du texte, du texte, 
du texte, du texte, et encore du texte...
\begin{figure}[ht]
  \centering
  \includegraphics[width=.3\linewidth]{example-image-a}
  \captionsetup{width=6cm,format=hang}
  \caption{La première figure, qui utilise l'option
    \texttt{format=hang} fournie par l'extension \textsf{caption}}
\end{figure}

Du texte, du texte, du texte, du texte, du texte, du texte, du texte, 
du texte, du texte, et encore du texte...
\begin{figure}[h]
  \centering
  \includegraphics[width=.3\linewidth]{example-image-b}
  \captionsetup{width=9cm,font=it}
  \caption{La deuxième figure, qui utilise l'option \texttt{font=it}
    fournie par l'extension \textsf{caption}}
\end{figure}

Du texte, du texte, du texte, du texte, du texte, du texte, du texte, 
du texte, du texte, et encore du texte...
\begin{figure}[h]
  \centering
  \captionsetup{position=top}
  \caption{La troisième figure, qui utilise l'option
    \texttt{position=top} fournie par l'extension \textsf{caption}}
  \includegraphics[width=.3\linewidth]{example-image-c}
\end{figure}

Du texte, du texte, du texte, du texte, du texte, du texte, du texte, 
du texte, du texte, et encore du texte...
\end{document}
```


### Avec les classes <ctanpkg:koma-script>

Les utilisateurs de classes <ctanpkg:koma-script> trouveront à la section 3.20
de la documentation (2.20 de la 
[traduction française](https://framabook.org/koma-script/)) les commandes 
et options permettant de modifier la mise en forme des légendes de flottants.