# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UpdateInstallProgress(Model):
    """Progress details during installation of updates.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar percent_complete: Percentage completed.
    :vartype percent_complete: int
    :ivar number_of_updates_to_install: Number of updates to install.
    :vartype number_of_updates_to_install: int
    :ivar number_of_updates_installed: Number of updates installed.
    :vartype number_of_updates_installed: int
    """

    _validation = {
        'percent_complete': {'readonly': True},
        'number_of_updates_to_install': {'readonly': True},
        'number_of_updates_installed': {'readonly': True},
    }

    _attribute_map = {
        'percent_complete': {'key': 'percentComplete', 'type': 'int'},
        'number_of_updates_to_install': {'key': 'numberOfUpdatesToInstall', 'type': 'int'},
        'number_of_updates_installed': {'key': 'numberOfUpdatesInstalled', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(UpdateInstallProgress, self).__init__(**kwargs)
        self.percent_complete = None
        self.number_of_updates_to_install = None
        self.number_of_updates_installed = None
